clear all

* Set Folder to output one

cd ..\Outputs

* Call database of merged unemployment and real GDP growth

use vin_all, clear

* Define the matrix of long-run restrictions

matrix lr = (.,0\.,.)

local sizeofwindow=120

quiet forvalues yy=107(2)117 {

	local qq=2
	if `yy'==117 local qq=1
	
	if `yy'<100 local str0="`yy'Q`qq'"
	if `yy'>=100 & `yy'<110 {
		local yy1=`yy'-100
		local str0="0`yy1'Q`qq'"
	}
	if `yy'>=110 {
		local yy1=`yy'-100
		local str0="`yy1'Q`qq'"
	}

	* Generate empty supply and demand decomposition to fill inside the loop
	
	tsset t

	gen dlogP_GA_tec`yy1'=.
	gen dlogP_GA_non`yy1'=.
	gen dlogE_GA_tec`yy1'=.
	gen dlogE_GA_non`yy1'=.

	* Define growth of output and unemployment as the last available vintage

	capture drop logemplo logprodu dlogemplo dlogprodu logY dlogY
	gen logemplo  = log(EMPLOY`str0')
	gen logprodu  = log(ROUTPUT`str0')-log(EMPLOY`str0')
	gen dlogemplo = d.logemplo
	gen dlogprodu = d.logprodu
	gen logY      = log(ROUTPUT`str0')
	gen dlogY     = d.logY
	
	summ t if dlogprodu!=.
	local lastt=r(max)

	* Run the Gali structural VAR

	noisily di "`yy'Q`qq'"
	svar dlogprodu dlogemplo if t>`=`lastt'-`sizeofwindow'', lags(1/8) lreq(lr) 
	matrix B=e(B)
	matrix invB=inv(B)
	capture drop resid*
	predict residP, resid equation(#1)
	predict residE, resid equation(#2)

	* Obtain structural residuals

	capture drop temp*
	gen temp_tec=invB[1,1]*residP+invB[1,2]*residE
	gen temp_non=invB[2,1]*residP+invB[2,2]*residE
	replace temp_tec=0 if temp_tec==. & t>`lastt'
	replace temp_non=0 if temp_non==. & t>`lastt'

	* Create IRF file for use inside the loop

	irf create lr, set(lrirf, replace) step(100) replace

	* Store IRF of productivity to technology shock

	preserve
	use lrirf.irf, clear
	keep if response == "dlogprodu"
	keep if impulse  == "dlogprodu"
	keep step sirf
	save temp1, replace
	restore

	* Store IRF of productivity to non-technology shock

	preserve
	use lrirf.irf, clear
	keep if response == "dlogprodu"
	keep if impulse  == "dlogemplo"
	keep step sirf
	save temp2, replace
	restore
	
	* Store IRF of Employment to technology shock

	preserve
	use lrirf.irf, clear
	keep if response == "dlogemplo"
	keep if impulse  == "dlogprodu"
	keep step sirf
	save temp3, replace
	restore

	* Store IRF of Employment to non-technology shock

	preserve
	use lrirf.irf, clear
	keep if response == "dlogemplo"
	keep if impulse  == "dlogemplo"
	keep step sirf
	save temp4, replace
	restore

	* Loop over time periods to generate historical decomposition

	sum t if e(sample)
	local mint=r(min)
	di "`mint'"
	local maxt=280
	di "`maxt'"
	local burn=0

	quiet forvalues period=`=`mint'+`burn''(1)`maxt' {

		noisily di "`period'"
		capture drop step
		gen step=`period'-t
		
		* Calculate historical decomposition: productivity to technology

		joinby step using temp1, unmatched(master)
		drop _merge

		capture drop temp_dlogP_GA_tec
		gen temp_dlogP_GA_tec=temp_tec*sirf 
		sum temp_dlogP_GA_tec
		replace dlogP_GA_tec`yy1'=r(mean)*r(N) if t==`period'

		capture drop sirf

		* Calculate historical decomposition: productivity to non-technology

		joinby step using temp2, unmatched(master)
		drop _merge

		capture drop temp_dlogP_GA_non
		gen temp_dlogP_GA_non=temp_non*sirf 
		sum temp_dlogP_GA_non
		replace dlogP_GA_non`yy1'=r(mean)*r(N) if t==`period'

		capture drop sirf
		
		* Calculate historical decomposition: employment to technology

		joinby step using temp3, unmatched(master)
		drop _merge

		capture drop temp_dlogE_GA_tec
		gen temp_dlogE_GA_tec=temp_tec*sirf 
		sum temp_dlogE_GA_tec
		replace dlogE_GA_tec`yy1'=r(mean)*r(N) if t==`period'

		capture drop sirf

		* Calculate historical decomposition: employment to non-technology

		joinby step using temp4, unmatched(master)
		drop _merge

		capture drop temp_dlogE_GA_non
		gen temp_dlogE_GA_non=temp_non*sirf 
		sum temp_dlogE_GA_non
		replace dlogE_GA_non`yy1'=r(mean)*r(N) if t==`period'

		capture drop sirf
		
	}
	
	gen dlogY_GA_tec`yy1'=dlogP_GA_tec`yy1'+dlogE_GA_tec`yy1'
	gen dlogY_GA_non`yy1'=dlogP_GA_non`yy1'+dlogE_GA_non`yy1'
	
	sum dlogY
	replace dlogY_GA_tec`yy1'=dlogY_GA_tec`yy1'+r(mean)
	replace dlogY_GA_non`yy1'=dlogY_GA_non`yy1'+r(mean)
	
}

gen   time      = year+(quarter-1)/4
local base      = 2007
summ t if time==`base'
local obsofbase = r(mean)

local baseindex = 2000
local counter=1
foreach var of varlist dlogY_GA_tec* GROUTPUT17Q1 {
	gen sap`counter'=.
	replace sap`counter'=0 if time==`baseindex'
	if `counter'<7  replace sap`counter'=sap`counter'[_n-1]+`var' if sap`counter'==. & time>`baseindex'
	if `counter'==7 replace sap`counter'=sap`counter'[_n-1]+`var'/400 if sap`counter'==. & time>`baseindex'
	local ++counter
}

ds sap*

foreach var of varlist `r(varlist)' {
	gen `var'base=`var'[`obsofbase']
	replace `var'=`var'-`var'base
	drop `var'base
}

local from      = 2004
local to        = 2017

twoway ///
(line sap1 time if year>=`from' & year<=`to', lcolor(red)) ///
(line sap2 time if year>=`from' & year<=`to', lcolor(green) lpattern(dash_dot)) ///
(line sap3 time if year>=`from' & year<=`to', lcolor(blue) lpattern(dash)) ///
(line sap4 time if year>=`from' & year<=`to', lcolor(black) lpattern(shortdash)) ///
(line sap5 time if year>=`from' & year<=`to', lcolor(teal) lpattern(shortdash_dot)) ///
(line sap6 time if year>=`from' & year<=`to', lcolor(purple) lpattern(longdash)) ///
(line sap7 time if year>=`from' & year<=`to', lcolor(black) lwidth(thick)) ///	
, ///
xlabel(`from'(2)`to') xtitle("Year") ///
ylabel(-0.1(0.05)0.3) ytitle("log deviation from 2007Q1") ///
legend(	label(1 "GA 2007") label(2 "GA 2009") label(3 "GA 2011") ///
		label(4 "GA 2013") label(5 "GA 2015") label(6 "GA 2017") ///
		label(7 "Actual") ring(0) position(11) rows(4)) ///
graphregion(color(white)) bgcolor(white) name(sap)

erase temp1.dta
erase temp2.dta
erase temp3.dta
erase temp4.dta

rename sap1 fig14GAL1
rename sap2 fig14GAL2
rename sap3 fig14GAL3
rename sap4 fig14GAL4
rename sap5 fig14GAL5
rename sap6 fig14GAL6

keep t year quarter time fig14GAL*

save fig14GAL, replace
